'use strict'

entityRegistry['system']['renderer'] = {
    init: (staticConfig) => {
        const {
            width, height, overscanSize,
        } = { ...staticConfig}

        renderer.setSize(width, height, overscanSize)
        fitScreen()

        return {}
    },
    staticConfig: [
        { paramName: 'width', displayName: 'Width', type: 'int', defaultValue: 640, triggerInit: true, uiOptions: { min: 256 }},
        { paramName: 'height', displayName: 'Height', type: 'int', defaultValue: 480, triggerInit: true, uiOptions: { min: 256 }},
        { paramName: 'overscanSize', displayName: 'Overscan Size', type: 'int', defaultValue: 0, triggerInit: true, uiOptions: { min: 0 }},
    ],
    actions: {
    }
}
